<?php
include 'db.php'; // Include your database connection file

header("Content-Type: application/json");

// Check if the request method is POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["status" => "error", "message" => "Invalid request method"]);
    exit;
}

// Retrieve input data from the request body
$data = json_decode(file_get_contents("php://input"), true);

// Extract input data
$name = $data['name'] ?? null;
$email = $data['email'] ?? null;
$phone = $data['phone'] ?? null;
$subject = $data['subject'] ?? null;
$message = $data['message'] ?? null;
$product_id = $data['product_id'] ?? null;


// Validate required fields
if (!$name || !$email ||  !$subject || !$message) {
    echo json_encode(["status" => "error", "message" => "Name, Email, Phone, Subject, Message, and Product ID are required"]);
    exit;
}

// Sanitize input to prevent SQL injection
$name = mysqli_real_escape_string($conn, $name);
$email = mysqli_real_escape_string($conn, $email);
$phone = mysqli_real_escape_string($conn, $phone);
$subject = mysqli_real_escape_string($conn, $subject);
$message = mysqli_real_escape_string($conn, $message);
$product_id = intval($product_id);

// Insert query to add a new entry to the enquiry_form table
$query = "INSERT INTO enquiry_form (name, email, phone, subject, message, product_id) 
          VALUES ('$name', '$email', '$phone', '$subject', '$message', $product_id)";

// Execute the query
if (mysqli_query($conn, $query)) {
    echo json_encode(["status" => "success", "message" => "Enquiry form submitted successfully"]);
} else {
    echo json_encode(["status" => "error", "message" => "Failed to submit enquiry form"]);
}
?>
